using System;

namespace OverloadedIndexer
{
	// Uproszczona kontrolka typu ListBox
	public class ListBoxTest
	{
		private string[] strings;
		private int ctr = 0;

		// Inicjowanie listy przy uyciu acuchw znakw 
		public ListBoxTest(params string[] initialStrings)
		{
			// Przydzielanie pamici dla acuchw znakw 
			strings = new String[256];

			// Kopiowanie acuchw znakw przekazanych do konstruktora 
			foreach (string s in initialStrings)
			{
				strings[ctr++] = s;
			}
		}

		// Dodaje pojedynczy acuch znakw na koniec listy
		public void Add(string theString)
		{
			if (ctr >= strings.Length)
			{
				// Obsuga niepoprawnych indeksw
			}
			else
			{
				strings[ctr++] = theString;
			}
		}


		// Umoliwia dostp jak do tablicy 
		public string this[int index]
		{
			get
			{
				if (index < 0 || index >= strings.Length)
				{
					// Obsuga niepoprawnych indeksw
				}
				return strings[index];
			}
			set
			{
				// Elementy mona dodawa jedynie przy uyciu metody add
				if (index >= ctr)
				{
					// Obsuga bdw
				}
				else
					strings[index] = value;
			}
		}

		private int FindString(string searchString)
		{
			for (int i = 0; i < strings.Length; i++)
			{
				if (strings[i].StartsWith(searchString))
				{
					return i;
				}
			}
			return -1;
		}

		// Indeksowanie przy uyciu acuchw znakw 
		public string this[string index]
		{
			get
			{
				if (index.Length == 0)
				{
					// Obsuga niepoprawnych indeksw
				}
				return this[FindString(index)];
			}
			set
			{
				// W tym miejscu nie trzeba sprawdza wartoci indeksw, poniewa
				// niepoprawne indeksy obsuguje metoda FindString
				strings[FindString(index)] = value;
			}
		}

		// Informuje, ile acuchw znakw znajduje si na licie
		public int GetNumEntries()
		{
			return ctr;
		}
	}

	public class Tester
	{
		static void Main()
		{
			// Tworzenie nowej listy i inicjowanie jej
			ListBoxTest lbt =
			   new ListBoxTest("Witaj", "wiecie");

			// Dodawanie kilku acuchw znakw 
			lbt.Add("Proust");
			lbt.Add("Faulkner");
			lbt.Add("Mann");
			lbt.Add("Hugo");

			// Testowanie dostpu
			string subst = "Wszechwiecie";
			lbt[1] = subst;
			lbt["Wit"] = "egnaj";
			// lbt["xyz"] = "uups";

			// Dostp do wszystkich acuchw znakw 
			for (int i = 0; i < lbt.GetNumEntries(); i++)
			{
				Console.WriteLine("lbt[{0}]: {1}", i, lbt[i]);
			} // Koniec for
		} // Koniec main
	} // Koniec tester
}
